#pragma once
// NetworkListDlg.h : header file
//
#include "stdafx.h"
#include "ListCtrlEx.h"
#include "resource.h"
#include "ConfigNWKDlg.h"
#include "ConfigNWK.h"

class CListCtrlMultiSelectEx : public CListCtrlEx
{
// Overrides
protected:
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CListCtrlMultiSelectEx)
	public:
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	//}}AFX_VIRTUAL
};

/////////////////////////////////////////////////////////////////////////////
// NetworkListDlg dialog

class CDlgNetworkList : public CDialog
{
// Construction
private:
	CConfigNWK*	mNwkCfg;
	UInt8 mCurrentList;
	UInt16	mPreviousSelection;
	BOOL mInited;

	Bool SaveSIMList();
	void InitSimNetworksList();
	void FillAvailableNetworksList();
	void FillPreferredNetworksList();
	void FillMaxNwk();
	
	void InitAllNetworksList();
	void FillAllNetworksList();
public:	
	CDlgNetworkList(CConfigNWK*	iNwkCfg, CWnd* pParent = NULL);   // standard constructor
	enum { IDD = IDD_NWK_LIST_DLG };
	CListCtrlMultiSelectEx	m_SimNwksListCtl;
	CListCtrlMultiSelectEx	m_AllNwksListCtl;
	CComboBox	m_NwkListSelectCtl;
	CButton		m_RemoveNwkCtl;
	CButton		m_AddNwkCtl;
	CButton		m_ApplyCtl;
	CButton		m_AutoShiftSimIdCtl;
	CEdit		mEditMaxNwk;

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

protected:

	afx_msg void OnButtonRemoveNetwork();
	afx_msg void OnButtonAddNetwork();
	afx_msg void OnButtonApply();
	afx_msg void OnSelchangeSimNwkList();
	afx_msg void OnCheckAutoShiftSimId();
	afx_msg void OnMaxNwkChange();
	virtual BOOL OnInitDialog();
	virtual void OnOK();
	virtual void OnCancel();
	Bool PrvConvertHexStringToUInt32( char* pString, UInt16 len, UInt32* pResult );
	DECLARE_MESSAGE_MAP()
};

